///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1042.C - Message 1042 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1042 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"
#include "utc_send.h"

void wait(float);  
void clear_message_line(void);   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1042 message from the ZMsgBuf.
//
void Dec1042(tMSGBUF *ZMsgBuf, tMSG1042 *Msg)
{
  unsigned i=0;
  extern short file_len;
  extern unsigned char filebuff[4000];
  
  file_len = 0;
  memset(&ZMsg.Msg1242, 0, sizeof(ZMsg.Msg1242));
  BldZMsg(ZMsgBuf, ZMsg, 1242);  
  for (i=0; i < sizeof(ZMsg.Msg1242) + HDR_LEN; i++, file_len++)
    filebuff[file_len] = (unsigned char)ZMsgBuf->byte[i];    /* Save Data To File Buffer */
  store_utc(file_len);

}                                      
